GTIADM
 ;Copyright (C) 2013 JPNA Trauma Center, All India Institute of Medical Sciences, India 
 ;jointly with GTI Infotel 
 ;
 ; This program is free software: you can redistribute it and/or modify
 ; it under the terms of the GNU Affero General Public License as
 ; published by the Free Software Foundation, either version 3 of the
 ; License, or (at your option) any later version.
 ;
 ; This program is distributed in the hope that it will be useful,
 ; but WITHOUT ANY WARRANTY; without even the implied warranty of
 ; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 ; GNU Affero General Public License for more details.
 ;
 ; You should have received a copy of the GNU Affero General Public License
 ; along with this program. If not, see <http://www.gnu.org/licenses/>.
 ;
 ;<GTI Infotel (http://www.gtiinfotel.com) is a VistA implementation 
 ;& integration Company that has developed GTIVistA, best of EHR complimented 
 ;by EWD based Practice Management System. Contact us vista@gtiinfotel.com>
 Q ""
EN(ssesid)
 S iAWL=$$getSessionValue^%zewdAPI("ward",sessid)
 S iARB=$$getSessionValue^%zewdAPI("roombed",sessid)
 S iAT=$$getSessionValue^%zewdAPI("facility",sessid) 
 S sAPP=$$getSessionValue^%zewdAPI("primaryphysician",sessid)
 S sAAP=$$getSessionValue^%zewdAPI("attendingphysician",sessid)
 S iATY=$$getSessionValue^%zewdAPI("atype",sessid)
 S iAS=$$getSessionValue^%zewdAPI("source",sessid)
 S iAR=$$getSessionValue^%zewdAPI("regulation",sessid)
 S sADign=$$getSessionValue^%zewdAPI("diag",sessid)
 Q:(iAWL="")!(iAWL="SELECT") "Choose Ward"
 Q:(iARB="")!(iARB="SELECT") "Choose Bed"
 Q:(iAT="")!(iAT="SELECT") "Choose Facility"
 Q:(sAPP="")!(sAPP="SELECT") "Choose Primary Physician"
 Q:(sAAP="")!(sAAP="SELECT") "Choose Attending Physician"
 Q:(sADign="")!(($ZCO(sADign,"U"))="SELECT") "Choose Diagosis"
 S:($ZCO(sADign,"U")="OTHER") sADign="OTHER"_$$getSessionValue^%zewdAPI("diagOther",sessid)
 Q:(sADign="OTHER") "Enter Other Diagnosis"
 S iAPP=sAPP,iAAP=sAAP
 Q:iAPP=iAAP "Primary and Attending Physician should not be Same"
 S DFN=$$getSessionValue^%zewdAPI("DFN",sessid)
 S DUZ=$$getSessionValue^%zewdAPI("DUZ",sessid)
 Q:DFN="" "DFN not Found!!"
 Q:DUZ="" "DUZ not Found!!"
 Q:$P($G(^DPT(DFN,.35)),"^")'="" "Patient was Died !!"
 Q:$D(^DPT(DFN,.1)) "Patient Already got Admitted in "_$G(^DPT(DFN,.1))
 S U="^",(CDR,WCDR,sAWL)=""
 S Tran=$P($G(^DG(405.1,iATY,0)),U,2),Mty=$P($G(^DG(405.1,iATY,0)),U,3) 
 S VAN=7,VAN(1)=9,VAV="VAEL" D ^VADPT0         
 S Egy=+$P($G(VAEL(1)),"^",1) 
 S Spec=$P($G(^DIC(45.7,iAT,0)),U,2) 
 S:Spec'="" CDR=$P($G(^DIC(42.4,Spec,0)),U,6) 
 S WSpe=$P($G(^DIC(42,iAWL,0)),U,12) 
 S:WSpe'="" WCDR=$P($G(^DIC(42.4,WSpe,0)),U,6) 
 S:iAWL'="" sAWL=$E($P($G(^DIC(42,iAWL,0)),U),1,30) 
 S:iARB'="" sARB=$P($G(^DG(405.4,iARB,0)),U) 
 D NOW^%DTC
 S cdt=%,cdate=$P(%,".")
 S nPTFF="+1,"
 S nPTF(45,nPTFF,.01)=DFN            
 S nPTF(45,nPTFF,2)=cdt             
 S nPTF(45,nPTFF,6)=0                
 S nPTF(45,nPTFF,11)=1               
 S nPTF(45,nPTFF,20)=iAS              
 S nPTF(45,nPTFF,20.1)=Egy          
 L ^DGPT
 D UPDATE^DIE("","nPTF",,"ERR")
 I $D(ERR("DIERR",1,"TEXT",1)) L -^DGPT Q $G(ERR("DIERR",1,"TEXT",1))
 S LPTF=$O(^DGPT(" "),-1)
 L -^DGPT
 S nPTF535F="+1,"_LPTF_","
 S nPTF535(45.0535,nPTF535F,.01)=1   
 S nPTF535(45.0535,nPTF535F,2)=WSpe 
 S nPTF535(45.0535,nPTF535F,3)=0     
 S nPTF535(45.0535,nPTF535F,4)=0     
 S nPTF535(45.0535,nPTF535F,6)=iAWL  
 S nPTF535(45.0535,nPTF535F,7)=1      
 S nPTF535(45.0535,nPTF535F,16)=WCDR  
 L ^DGPT
 D UPDATE^DIE("","nPTF535",,"ERR")
 I $D(ERR("DIERR",1,"TEXT",1)) L -^DGPT Q $G(ERR("DIERR",1,"TEXT",1)) 
 L -^DGPT
 S nPTF02F="+1,"_LPTF_","
 S nPTF02(45.02,nPTF02F,.01)=1       
 S nPTF02(45.02,nPTF02F,2)=Spec      
 S nPTF02(45.02,nPTF02F,3)=0         
 S nPTF02(45.02,nPTF02F,4)=0         
 S nPTF02(45.02,nPTF02F,10)=cdt      
 S nPTF02(45.02,nPTF02F,16)=CDR      
 S nPTF02(45.02,nPTF02F,21)="S"      
 S nPTF02(45.02,nPTF02F,22)=cdate    
 S nPTF02(45.02,nPTF02F,23)=1        
 S nPTF02(45.02,nPTF02F,24)=iAPP     
 S nPTF02(45.02,nPTF02F,25)=1       
 L ^DGPT
 D UPDATE^DIE("","nPTF02",,"ERR")
 I $D(ERR("DIERR",1,"TEXT",1)) L -^DGPT Q $G(ERR("DIERR",1,"TEXT",1))
 L -^DGPT
 S nPMF="+1,"
 S nPM(405,nPMF,.01)=cdt                     
 S nPM(405,nPMF,.02)=Tran            
 S nPM(405,nPMF,.03)=DFN             
 S nPM(405,nPMF,.04)=iATY            
 S nPM(405,nPMF,.06)=iAWL           
 S nPM(405,nPMF,.07)=iARB           
 S nPM(405,nPMF,.1)=sADign          
 S nPM(405,nPMF,.12)=iAR             
 S nPM(405,nPMF,.16)=LPTF            
 S nPM(405,nPMF,.18)=Mty            
 S nPM(405,nPMF,.22)=0              
 S nPM(405,nPMF,.25)=0               
 S nPM(405,nPMF,41)=0                
 S nPM(405,nPMF,42)=cdt              
 S nPM(405,nPMF,43)=DUZ              
 S nPM(405,nPMF,100)=DUZ             
 S nPM(405,nPMF,101)=cdt            
 S nPM(405,nPMF,102)=DUZ            
 S nPM(405,nPMF,103)=cdt             
 L ^DGPM 
 S LPM=$O(^DGPM(" "),-1)
 S nPM(405,nPMF,.14)=LPM+1             
 D UPDATE^DIE("","nPM",,"ERR")
 I $D(ERR("DIERR",1,"TEXT",1)) L -^DGPM Q $G(ERR("DIERR",1,"TEXT",1))
 S LPM=$O(^DGPM(" "),-1)
 L -^DGPM  
 S nPM01F=LPM_","
 S nPM01(405,nPM01F,.08)=iAPP           
 S nPM01(405,nPM01F,.09)=iAT             
 S nPM01(405,nPM01F,.19)=iAAP           
 L ^DGPM 
 D FILE^DIE("","nPM01","ERR") 
 I $D(ERR("DIERR",1,"TEXT",1)) Q $G(ERR("DIERR",1,"TEXT",1))       
 L -^DGPM
 S nPM99F=LPM_","
 I sADign'="" D
 . S WP(1)=sADign
 . D WP^DIE(405,nPM99F,99,"K","WP","ERR")
 I $D(ERR("DIERR",1,"TEXT",1)) Q $G(ERR("DIERR",1,"TEXT",1))
 S nPATF=DFN_","
 S nPAT(2,nPATF,.1)=sAWL             
 S nPAT(2,nPATF,.101)=sARB          
 S nPAT(2,nPATF,.102)=LPM            
 S nPAT(2,nPATF,.103)=iAT            
 S nPAT(2,nPATF,.104)=iAPP           
 S nPAT(2,nPATF,.1041)=iAAP          
 S nPAT(2,nPATF,.105)=LPM            
 S nPAT(2,nPATF,.108)=iARB           
 S nPAT(2,nPATF,.109)=0              
 L ^DPT
 D FILE^DIE("","nPAT","ERR")
 I $D(ERR("DIERR",1,"TEXT",1)) L -^DPT Q $G(ERR("DIERR",1,"TEXT",1))       
 L -^DPT
 I '$D(^PS(55,DFN)) D
 . S nPSF="+1,",nPSN(1)=DFN
 . S nPS(55,nPSF,.01)=DFN
 . S nPS(55,nPSF,62.03)=cdt
 . L ^PS
 . D UPDATE^DIE("","nPS","nPSN","ERR") 
 . L -^PS
 I $D(ERR("DIERR",1,"TEXT",1)) Q $G(ERR("DIERR",1,"TEXT",1))   
 D setSessionValue^%zewdAPI("ADFN",LPM,sessid)
 D setSessionValue^%zewdAPI("PADT","ADM",sessid)
 Q ""
LBED(sessid)
 S U="^"
 S iAWL=$$getRequestValue^%zewdAPI("ward",sessid)
 Q:iAWL="" "Ward not getting!!"
 S iAWL=$ZCO(iAWL,"U"),sAWL=$P($G(^DIC(42,iAWL,0)),U) 
 D clearList^%zewdAPI("roombed",sessid)
 I (iAWL="SELECT")!(iAWL="") D  Q ""
 . D appendToList^%zewdAPI("roombed","Select Ward","SELECT",sessid) 
 D appendToList^%zewdAPI("roombed","Select","SELECT",sessid)
 I '$D(^DG(405.4,"W",iAWL)) Q "No Bed is Configured for this Ward!!"
 S cnt=""
 S iRB="" F  S iRB=$O(^DG(405.4,"W",iAWL,iRB)) Q:iRB=""  D
 . S sRB=$P($G(^DG(405.4,iRB,0)),U)
 . Q:$D(^DPT("RM",sRB)) ;Already bed filled
 . S cnt=$I(cnt)
 . D appendToList^%zewdAPI("roombed",sRB,iRB,sessid)
 D setSessionValue^%zewdAPI("roombed","SELECT",sessid)
 Q:(+cnt)=0 "Bed is not Available for "_sAWL_" Ward right now!!"
 Q ""
LDIAG(sessid)
 S U="^"
 S iAT=$$getRequestValue^%zewdAPI("facility",sessid)
 Q:iAT="" "Ward not getting!!"
 S iAT=$ZCO(iAT,"U")
 D clearList^%zewdAPI("diag",sessid)
 I (iAT="SELECT")!(iAT="") D  Q ""
 . D appendToList^%zewdAPI("diag","Select Facility","SELECT",sessid) 
 D appendToList^%zewdAPI("diag","Select","SELECT",sessid)
 I iAT=34 D 
 . D appendToList^%zewdAPI("diag","Head Injury","Head Injury",sessid) 
 . D appendToList^%zewdAPI("diag","Spinal Injury (Cervical)","Spinal Injury (Cervical)",sessid) 
 . D appendToList^%zewdAPI("diag","Spinal Injury (Dorsolumbar)","Spinal Injury (Dorsolumbar)",sessid) 
 . D appendToList^%zewdAPI("diag","Brachial Plexus + Peripheral Nerve","Brachial Plexus + Peripheral Nerve",sessid) 
 . D appendToList^%zewdAPI("diag","Hydrocephalus","Hydrocephalus",sessid) 
 . D appendToList^%zewdAPI("diag","For Cranioplasty","For Cranioplasty",sessid) 
 . D appendToList^%zewdAPI("diag","Other","Other",sessid) 
 I iAT=35 D
 . D appendToList^%zewdAPI("diag","Abdominal Trauma","Abdominal Trauma",sessid) 
 . D appendToList^%zewdAPI("diag","Chest Trauma","Chest Trauma",sessid) 
 . D appendToList^%zewdAPI("diag","Thoracoabdominall Trauma","Thoracoabdominall Trauma",sessid) 
 . D appendToList^%zewdAPI("diag","Neck Injuries","Neck Injuries",sessid) 
 . D appendToList^%zewdAPI("diag","Facio Maxillary Trauma","Facio Maxillary Trauma",sessid) 
 . D appendToList^%zewdAPI("diag","Vascular Injury","Vascular Injury",sessid) 
 . D appendToList^%zewdAPI("diag","Soft Tissue Injury","Soft Tissue Injury",sessid) 
 . D appendToList^%zewdAPI("diag","Cardiac Injury","Cardiac Injury",sessid) 
 . D appendToList^%zewdAPI("diag","Other","Other",sessid) 
 I iAT=36 D
 . D appendToList^%zewdAPI("diag","Pelvis Acetabular Injury","Pelvis Acetabular Injury",sessid) 
 . D appendToList^%zewdAPI("diag","Spine Injury","Spine Injury",sessid) 
 . D appendToList^%zewdAPI("diag","Sports Related Injury","Sports Related Injury",sessid) 
 . D appendToList^%zewdAPI("diag","Multiple Injury / Fracture","Multiple Injury / Fracture",sessid) 
 . D appendToList^%zewdAPI("diag","Compound Fracture / Amputations","Compound Fracture / Amputations",sessid) 
 . D appendToList^%zewdAPI("diag","Lower Limbs - Femur, Tibia","Lower Limbs - Femur, Tibia",sessid) 
 . D appendToList^%zewdAPI("diag","Lower Limb - Foot / Ankle","Lower Limb - Foot / Ankle",sessid) 
 . D appendToList^%zewdAPI("diag","Upper Limb - Humerus, Forearm","Upper Limb - Humerus, Forearm",sessid) 
 . D appendToList^%zewdAPI("diag","Upper Limb - Hand","Upper Limb - Hand",sessid) 
 . D appendToList^%zewdAPI("diag","Other","Other",sessid) 
 D setSessionValue^%zewdAPI("diag","SELECT",sessid)
 Q ""
LOAD(sessid)
 S U="^"
 D deleteFromSession^%zewdAPI("ward",sessid)
 D deleteFromSession^%zewdAPI("roombed",sessid)
 D deleteFromSession^%zewdAPI("facility",sessid) 
 D deleteFromSession^%zewdAPI("primaryphysician",sessid)
 D deleteFromSession^%zewdAPI("attendingphysician",sessid)
 D deleteFromSession^%zewdAPI("atype",sessid)
 D deleteFromSession^%zewdAPI("source",sessid)
 D deleteFromSession^%zewdAPI("regulation",sessid)
 D deleteFromSession^%zewdAPI("diag",sessid)
 D deleteFromSession^%zewdAPI("name",sessid)
 D deleteFromSession^%zewdAPI("sex",sessid)
 D deleteFromSession^%zewdAPI("age",sessid)
 D deleteFromSession^%zewdAPI("ADFN",sessid)
 D deleteFromSession^%zewdAPI("PADT",sessid)
 D deleteFromSession^%zewdAPI("diagOther",sessid)
 S DFN=$$getSessionValue^%zewdAPI("DFN",sessid)
 Q:DFN="" "DFN is null"
 S name=$$PROV($$GET1^DIQ(2,DFN,.01))
 S sex=$$GET1^DIQ(2,DFN,.02)
 S age=$$GET1^DIQ(2,DFN,.033)
 D clearList^%zewdAPI("ward",sessid)
 D clearList^%zewdAPI("roombed",sessid)
 D appendToList^%zewdAPI("ward","Select","SELECT",sessid)
 S iLWL=$P($G(^DIC(42,0)),U,4) F iWL=1:1:iLWL D
 . D appendToList^%zewdAPI("ward",$P($G(^DIC(42,iWL,0)),U),iWL,sessid)
 D setSessionValue^%zewdAPI("ward","SELECT",sessid)
 D clearList^%zewdAPI("facility",sessid)
 D clearList^%zewdAPI("diag",sessid)
 D appendToList^%zewdAPI("facility","Select","SELECT",sessid)
 F iFac=34,35,36 D appendToList^%zewdAPI("facility",$P($G(^DIC(45.7,iFac,0)),U),iFac,sessid)
 D setSessionValue^%zewdAPI("facility","SELECT",sessid)
 D clearList^%zewdAPI("primaryphysician",sessid)
 D clearList^%zewdAPI("attendingphysician",sessid) 
 D clearList^%zewdAPI("atype",sessid)
 S iTy="" F iTy=1,2,3,4,5  D
 . Q:'(+$P($G(^DG(405.1,iTy,0)),U,4)) ;Active or InActive
 . D appendToList^%zewdAPI("atype",$P($G(^DG(405.1,iTy,0)),U),iTy,sessid)
 D clearList^%zewdAPI("source",sessid)
 F i=1,2,3,4,5 D
 . S arrAdS($I(cnt))=$P($G(^DIC(45.1,i,0)),U,2)_U_i
 . D appendToList^%zewdAPI("source",$P(arrAdS(cnt),U),i,sessid)
 D clearList^%zewdAPI("regulation",sessid)
 F i=1,2,3,4,5,6 D appendToList^%zewdAPI("regulation",$P($G(^DIC(43.4,i,0)),U),i,sessid)
 D setSessionValue^%zewdAPI("regulation",6,sessid)
 D setSessionValue^%zewdAPI("name",name,sessid)
 D setSessionValue^%zewdAPI("sex",sex,sessid)
 D setSessionValue^%zewdAPI("age",age,sessid)
 Q ""
PROV(PROV)
 Q:PROV="" ""
 Q $P(PROV,",",2)_" "_$P(PROV,",")


